///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _INIT_CPP
#define _INIT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CMemPool/CMemPool.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/Common.H"
#include "../../SharedSource/CRC32.H"
#include "../../SharedSource/EventLog.H"

#include "Init.H"
#include "Entry.H"
#include "Routines.H"

#include "../CSockSrvr/CSockSrvr.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool InitializeApp(void)
{
    LoadString(ghAppInstance, IDS_APPCOPYRIGHT, gsAppCopyRight, sizeof(gsAppCopyRight));
    LoadString(ghAppInstance, IDS_FILEVERSION, gsFileVersion, sizeof(gsFileVersion));
    LoadString(ghAppInstance, IDS_TITLECAPTION, gsTitleCaption, sizeof(gsTitleCaption));
    LoadString(ghAppInstance, IDS_REGISTRYKEY, gsRegistryKey, sizeof(gsRegistryKey));
    LoadString(ghAppInstance, IDS_EVENTNAME, gsEventName, sizeof(gsEventName));

	GetBuildMutexName(gsRegistryKey, sizeof(gsRegistryKey), gsRegistryKey);
	GetBuildMutexName(gsEventName, sizeof(gsEventName), gsEventName);

	InitializeCriticalSection(&csTransPerSecond);

	if(!gbExcludeInit)
	{
		if(IsApplicationRunning())
		{
			return false;
		}
	}

	memset(&gMem, 0, sizeof(gMem));

	if(!gMem.Init())
	{
        MessageBox(NULL, "Failed to Initialize the Memory Pool.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
		return false;
	}

	InitializeCRCTable();

	memset(&MDI, 0, sizeof(MDI));
	memset(&gServer, 0, sizeof(gServer));
	
	if(!gSC.InitializeCryptographyEx(CRYPTKEY, strlen(CRYPTKEY), true))
	{
        MessageBox(NULL, "Failed to Initialize Cryptography Set CSockSrvr.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
		RecordError("Failed to Initialize Cryptography Set CSockSrvr.");
        return false;
	}

	if(!GetRegistryValues())
	{
		MessageBox(NULL, "Failed to get registry values.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
        return false;
	}

	if(!gbExcludeInit)
	{
		if(!OpenLogFile())
		{
			MessageBox(NULL, "Failed to open log file.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
			return false;
		}

		if(!gServer.Initialize(gdwListenPort, gdwMaxClients, !gbPacketMode, gbDropBadPackets, SENDBUFSZ, RECVBUFSZ))
		{
			WriteSysLogEx("Failed to Initialize the CSockSrvr.", EVENT_ERROR);
			return false;
		}

		gServer.SetNextClientID(gdwNextClientID);

		if((CCI = (_ConnectedClientInfo *) gMem.Allocate(gdwMaxClients, sizeof(_ConnectedClientInfo))) == NULL)
		{
			WriteSysLogEx("Failed to Initialize the ClientInfo structure.", EVENT_ERROR);
			Assert(!CCI, "Memory Allocation Error.");
			return false;
		}
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool UninitializeApp(void)
{
	SaveRegistryValues();

	if(!gbExcludeInit)
	{
		if(!gServer.UnInitialize())
		{
			WriteSysLogEx("Failed to UnInitialize the CSockSrvr.", EVENT_ERROR);

			return 0;
		}

		gMem.Free(CCI);

		CloseLogFile();
	}

	gMem.Destroy();

	DeleteCriticalSection(&csTransPerSecond);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
